/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserInterface;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlInlinePopupContainerPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlPopupPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.report.xmlreport.CVXMLReportReader;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class BaselineReportGenerator {
    private HashMap<String, CVXMLReportReader> m_reportList = new LinkedHashMap<String, CVXMLReportReader>();
    private MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private List<String> m_mismatches = new ArrayList<String>();
    private int m_delta = 10;

    public BaselineReportGenerator(String xmlFileList) throws XmlReportToolException {
        String[] xmlFilePathArray;
        for (String xmlFilePath : xmlFilePathArray = xmlFileList.split(",")) {
            CVXMLReportReader reader = new CVXMLReportReader(xmlFilePath);
            ReportUtilConstants.BasicClusterWareDetails header = reader.getHeader();
            String xmlFileName = new File(xmlFilePath).getName();
            String[] timeStamp = this.getTimeStamp(header.getTimeStamp(), "/", ":");
            String timeStampStr = "";
            if (timeStamp != null && timeStamp.length > 1) {
                timeStampStr = timeStamp[0] + " " + timeStamp[1];
            }
            String reportName = "";
            String reportKey = reportName + " " + timeStampStr + " [" + xmlFileName + "]";
            this.m_reportList.put(reportKey, reader);
        }
        String deltaString = VDMUtil.getDefaultBaselineDelta();
        if (VerificationUtil.isStringGood(deltaString)) {
            this.m_delta = Integer.parseInt(deltaString);
        }
    }

    private void createHTMLHead(ReportUtilConstants.ReportContext context, HtmlPage htmlDoc) {
        Text heading = null;
        if (context == ReportUtilConstants.ReportContext.BEST_PRACTICE) {
            try {
                heading = new Text("CVU Baseline Report");
                heading.setBookMarkName("MAIN");
                htmlDoc.addHeadingToHtmlBody(heading, 3, HtmlConstants.HorizontalAlignment.center);
            }
            catch (HtmlReportToolException e) {
                Trace.out((String)("Exception in CreateHTMLHead : " + e.getMessage()));
            }
        }
    }

    public void xmlToHtml(String title, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        this.xmlToHtml(title, null, showFailuresOnly, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    public void xmlToHtml(String title, String author, boolean showFailuresOnly, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        this.xmlToHtml(title, author, showFailuresOnly, HtmlConstants.Colors.Cornsilk, context, showInBrowser, browserPath, saveFile, saveDirPath);
    }

    public void xmlToHtml(String title, String author, boolean showFailuresOnly, HtmlConstants.Colors backGroundColor, ReportUtilConstants.ReportContext context, boolean showInBrowser, String browserPath, boolean saveFile, String saveDirPath) throws ReportToolException, XmlFilePathException, HtmlBrowserException, XmlReportToolException {
        HtmlInlinePopupContainerPage mainPage = new HtmlInlinePopupContainerPage(title, author, backGroundColor, true);
        this.createHTMLHead(context, mainPage);
        Table mainTargetTable = new Table(1);
        LinkedHashMap<String, HashMap<String, String>> targetHM = new LinkedHashMap<String, HashMap<String, String>>();
        for (String reportName : this.m_reportList.keySet()) {
            CVXMLReportReader reader = this.m_reportList.get(reportName);
            targetHM.putAll(reader.getTargetList());
        }
        ArrayList<Text> listOfTargetNames = new ArrayList<Text>();
        Text topSymbol = new Text("&#8593;" + this.s_rptMsgBundle.getMessage("10055", false) + "&#8593;");
        topSymbol.setTextColor(HtmlConstants.Colors.DarkBlue);
        topSymbol.setBold(true);
        topSymbol.setReferencelink("#MAIN");
        topSymbol.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10043", false));
        String topSymbolHtmlText = topSymbol.toHtmlString();
        String dbName = null;
        int cnt = -1;
        for (String targetKey : ((HashMap)targetHM).keySet()) {
            String captionMsg;
            ++cnt;
            ReportUtilConstants.TargetType targetType = null;
            Text targetHead = null;
            HashMap attributes = (HashMap)((HashMap)targetHM).get(targetKey);
            String targetStr = (String)attributes.get("ID");
            if (!VerificationUtil.isStringGood(targetStr)) {
                Trace.out((String)"skipping without adding any target because target type null");
                continue;
            }
            if (targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_CRS_INST.getID())) {
                captionMsg = s_prvgMsgBundle.getMessage("11618", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_CRS_INST.getID())) {
                captionMsg = s_prvgMsgBundle.getMessage("11620", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.CLUSTER_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_PRE_CRS_INST.getID())) {
                captionMsg = s_prvgMsgBundle.getMessage("11619", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else if (targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_CRS_INST.getID())) {
                captionMsg = s_prvgMsgBundle.getMessage("11621", false);
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.SYSTEM_BASED_CHECKS;
            } else {
                if (!targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_CONFIG.getID()) && !targetStr.trim().equalsIgnoreCase(VerificationType.PREREQ_DB_INST.getID()) && !targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) && !targetStr.trim().equalsIgnoreCase(VerificationType.POSTREQ_DB_CONFIG.getID())) continue;
                captionMsg = null;
                dbName = (String)attributes.get("DATABASENAME");
                captionMsg = targetStr.trim().equalsIgnoreCase(VerificationType.BESTPRACTICE_POSTREQ_DB_CONFIG.getID()) ? s_prvgMsgBundle.getMessage("11623", false, (Object[])new String[]{dbName}) : s_prvgMsgBundle.getMessage("11622", false, (Object[])new String[]{dbName});
                targetHead = new Text(captionMsg);
                targetType = ReportUtilConstants.TargetType.DATABASE_CHECKS;
            }
            Table targetTable = null;
            targetTable = this.m_reportList.size() == 1 ? this.createHtmlTableForSingleBaseLine("TARGET" + Integer.toString(cnt + 1), targetHead.getTextData(), targetKey, targetType, showFailuresOnly, mainPage, topSymbolHtmlText) : this.createHtmlTableForMultipleBaseLines("TARGET" + Integer.toString(cnt + 1), targetHead.getTextData(), targetKey, targetType, showFailuresOnly, mainPage, topSymbolHtmlText);
            if (targetTable.getRowCount() == 0) continue;
            targetHead.setReferencelink("#TARGET" + Integer.toString(cnt + 1));
            targetHead.setTextColor(HtmlConstants.Colors.MediumBlue);
            listOfTargetNames.add(targetHead);
            TableCell row = new TableCell(targetTable, HtmlConstants.Colors.Gainsboro, null, HtmlConstants.HorizontalAlignment.center);
            mainTargetTable.addRow(new TableCell[]{row});
        }
        mainPage.addListToHtmlBody(listOfTargetNames.toArray(new Text[0]), true);
        mainPage.addTableToHtmlBody(mainTargetTable, HtmlConstants.HorizontalAlignment.center);
        if (showInBrowser) {
            HtmlBrowserInterface.showHtmlInBrowser(mainPage, browserPath);
        }
    }

    private HashMap<String, List<CollectionElement>> getCollectionSet(String targetKey, CVXMLReportReader reader) throws XmlReportToolException {
        List<Task> taskList = reader.getTaskList(targetKey);
        LinkedHashMap<String, List<CollectionElement>> sortedColletionHashTable = new LinkedHashMap<String, List<CollectionElement>>();
        LinkedHashMap<String, List> errorCollectionMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> warnCollectionMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> sucCollectionMap = new LinkedHashMap<String, List>();
        for (Task task : taskList) {
            LinkedHashMap<String, ArrayList<CollectionElement>> collectionHashTable = new LinkedHashMap<String, ArrayList<CollectionElement>>();
            ResultSet resultSet = task.getResultSet();
            Hashtable t = resultSet.getResultTable();
            Enumeration nodeKeys = t.keys();
            while (nodeKeys.hasMoreElements()) {
                String node = (String)nodeKeys.nextElement();
                Result result = (Result)t.get(node);
                for (CollectionElement element : result.getCollectionElements()) {
                    ArrayList<CollectionElement> collectionList = null;
                    collectionList = (ArrayList<CollectionElement>)((HashMap)collectionHashTable).get(element.getName());
                    if (collectionList == null) {
                        collectionList = new ArrayList<CollectionElement>();
                        collectionHashTable.put(element.getName(), collectionList);
                    }
                    collectionList.add(element);
                }
            }
            for (String collectionName : ((HashMap)collectionHashTable).keySet()) {
                boolean hasError = false;
                boolean hasWarn = false;
                List collectionList = (List)((HashMap)collectionHashTable).get(collectionName);
                for (CollectionElement element : collectionList) {
                    if (element.getStatus() == 2 || element.getStatus() == 3) {
                        hasError = true;
                        break;
                    }
                    if (element.getStatus() != 4) continue;
                    hasWarn = true;
                }
                if (hasError) {
                    errorCollectionMap.put(collectionName, collectionList);
                    continue;
                }
                if (hasWarn) {
                    warnCollectionMap.put(collectionName, collectionList);
                    continue;
                }
                sucCollectionMap.put(collectionName, collectionList);
            }
        }
        sortedColletionHashTable.putAll(errorCollectionMap);
        sortedColletionHashTable.putAll(warnCollectionMap);
        sortedColletionHashTable.putAll(sucCollectionMap);
        return sortedColletionHashTable;
    }

    private String[] getTimeStamp(Calendar calendar, String dateSep, String timeSep) {
        String[] timeStampArray = null;
        String dateStr = null;
        String timeStr = null;
        String dateDelim = dateSep;
        String timeDelim = timeSep;
        if (calendar != null) {
            int day = calendar.get(5);
            int month = calendar.get(2);
            int year = calendar.get(1);
            String dayStr = day + "";
            String monthStr = month + "";
            if (dayStr.length() == 1) {
                dayStr = "0" + day;
            }
            if (monthStr.length() == 1) {
                monthStr = "0" + month;
            }
            dateStr = dateDelim != null ? monthStr + dateDelim + dayStr + dateDelim + year : monthStr + dayStr + year;
            int hours = calendar.get(10);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            String hoursStr = hours + "";
            String minutesStr = minutes + "";
            String secondsStr = seconds + "";
            if (hoursStr.length() == 1) {
                hoursStr = "0" + hours;
            }
            if (minutesStr.length() == 1) {
                minutesStr = "0" + minutes;
            }
            if (secondsStr.length() == 1) {
                secondsStr = "0" + seconds;
            }
            timeStr = timeDelim != null ? hoursStr + timeSep + minutesStr + timeSep + secondsStr : hoursStr + minutesStr + secondsStr;
        }
        if (VerificationUtil.isStringGood(timeStr) && VerificationUtil.isStringGood(dateStr)) {
            timeStampArray = new String[]{dateStr, timeStr};
        }
        return timeStampArray;
    }

    private Table createHtmlTableForSingleBaseLine(String reference, String targetName, String targetKey, ReportUtilConstants.TargetType targetType, boolean showFailuresOnly, HtmlPage htmlPage, String topNavigationTxt) throws ReportToolException, XmlReportToolException {
        int numberOfColumns = 5;
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        CVXMLReportReader reader = this.m_reportList.values().iterator().next();
        ReportUtilConstants.BasicClusterWareDetails clusterWareDetails = reader.getHeader();
        String reportKey = this.m_reportList.keySet().iterator().next();
        Text topSymbol = new Text("&#8593;" + this.s_rptMsgBundle.getMessage("10055", false) + "&#8593;");
        topSymbol.setTextColor(HtmlConstants.Colors.DarkBlue);
        topSymbol.setBold(true);
        topSymbol.setReferencelink("#MAIN");
        topSymbol.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10043", false));
        String topSymbolHtmlText = topSymbol.toHtmlString();
        Text targetDefination = new Text(targetName);
        targetDefination.setFontSize(5);
        targetDefination.setBold(true);
        targetDefination.setBookMarkName(reference);
        targetDefination.setTextColor(HtmlConstants.Colors.DarkGreen);
        HtmlConstants.Colors headerColor = HtmlConstants.Colors.LightSteelBlue;
        String captionStr = VerificationConstants.LINE_SEPARATOR + VerificationConstants.LINE_SEPARATOR + topSymbolHtmlText + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + targetDefination.toHtmlString() + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + topSymbolHtmlText;
        Text caption = new Text(captionStr);
        TableCell[] headers = new TableCell[numberOfColumns - 3];
        headers[0] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10003", false)), headerColor, null, null);
        headers[1] = new TableCell(new Text(reportKey), headerColor, null, null);
        headers[1].setColSpan(4);
        headers[0].setWidth(30);
        headers[1].setWidth(70);
        String idTextStr = this.s_rptMsgBundle.getMessage(targetType.name().contains("DATABASE") ? "10022" : "10052", false);
        TableCell[] secondHeaders = new TableCell[numberOfColumns];
        secondHeaders[0] = new TableCell(new Text(""), headerColor, null, null);
        Text idText = new Text(idTextStr);
        idText.setBold(true);
        secondHeaders[1] = new TableCell(idText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
        Text actualValueText = new Text(this.s_rptMsgBundle.getMessage("10025", false));
        actualValueText.setBold(true);
        secondHeaders[2] = new TableCell(actualValueText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
        Text expectedValueHeaderText = new Text(this.s_rptMsgBundle.getMessage("10024", false));
        expectedValueHeaderText.setBold(true);
        secondHeaders[3] = new TableCell(expectedValueHeaderText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
        Text statusText = new Text(this.s_rptMsgBundle.getMessage("10056", false));
        statusText.setBold(true);
        secondHeaders[4] = new TableCell(statusText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
        secondHeaders[0].setWidth(30);
        secondHeaders[1].setWidth(15);
        secondHeaders[2].setWidth(20);
        secondHeaders[3].setWidth(20);
        secondHeaders[4].setWidth(15);
        Table table = new Table(caption, headers, HtmlConstants.Colors.Black, HtmlConstants.Colors.DarkGoldenRod, 0);
        table.setWidth(98);
        table.addRow(secondHeaders);
        HashMap<String, List<CollectionElement>> collectionHash = this.getCollectionSet(targetKey, reader);
        Set<String> collectionKeySet = collectionHash.keySet();
        for (String collectionName : collectionKeySet) {
            String msg = s_prvgMsgBundle.getMessage("11616", false, (Object[])new String[]{collectionName});
            ReportUtil.quietprintln(msg);
            HtmlConstants.Colors rowColor = HtmlConstants.Colors.LightGrey;
            Text collectionNameText = new Text("");
            Text expectedValueText = new Text(notApplicable);
            List<CollectionElement> nodeCollectionList = collectionHash.get(collectionName);
            String str = "";
            for (int j = 0; j < nodeCollectionList.size(); ++j) {
                CollectionElement collectionElement = nodeCollectionList.get(j);
                HtmlConstants.Colors collectionRowColor = null;
                collectionRowColor = (j + 1) % 2 == 0 ? HtmlConstants.Colors.LightGrey : HtmlConstants.Colors.LightGrey;
                if (j == 0) {
                    str = collectionElement.getName();
                    if (VerificationUtil.isStringGood(str)) {
                        collectionNameText = new Text(str);
                    }
                    if (VerificationUtil.isStringGood(str = collectionElement.getDescription())) {
                        HtmlPopupPage popUpPage = this.createCollectionDescPopupPage("", str, htmlPage.getBackgroundColor());
                        collectionNameText.setInlinePopUpWindowsLink("#DESC", popUpPage);
                        collectionNameText.setTextColor(HtmlConstants.Colors.Black);
                    }
                }
                TableCell[] collectionRow = new TableCell[3];
                Text nodeNameText = new Text(collectionElement.getNode());
                collectionRow[0] = new TableCell(nodeNameText, null, HtmlConstants.VeriticalAlignment.top, null);
                String collectionStatus = collectionElement.getStatusString().replaceAll("_", " ").toLowerCase();
                Text collectionStatusText = new Text(collectionStatus);
                HtmlConstants.Colors verificationColor = HtmlConstants.Colors.Green;
                verificationColor = VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("success") ? HtmlConstants.Colors.Green : (VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("warning") ? HtmlConstants.Colors.Darkorange : (VerificationUtil.isStringGood(collectionStatus) && collectionStatus.toLowerCase().contains("failed") ? HtmlConstants.Colors.Red : HtmlConstants.Colors.OrangeRed));
                collectionStatusText.setTextColor(verificationColor);
                List<ErrorDescription> errorList = collectionElement.getErrorDescriptionList();
                if (errorList != null && errorList.size() > 0) {
                    HtmlPopupPage popUpPage = this.createCollectionErrorPopupPage("", errorList, htmlPage.getBackgroundColor());
                    collectionStatusText.setInlinePopUpWindowsLink("#DESC", popUpPage);
                }
                collectionRow[2] = new TableCell(collectionStatusText, null, HtmlConstants.VeriticalAlignment.top, null);
                if (collectionElement.getExpectedValue() != null) {
                    expectedValueText.setTextData(String.valueOf(collectionElement.getExpectedValue()));
                }
                Text actualValTxt = new Text(notAvailable);
                if (collectionElement.getValue() != null) {
                    actualValTxt.setTextData(collectionElement.getValue().toString());
                    if (!HtmlConstants.Colors.Green.equals((Object)verificationColor)) {
                        actualValTxt.setTextColor(verificationColor);
                    }
                }
                TableCell[] row = null;
                if (j == 0) {
                    row = new TableCell[numberOfColumns];
                    row[0] = new TableCell(collectionNameText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[0].setRowSpan(nodeCollectionList.size());
                    row[1] = new TableCell(nodeNameText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[2] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[3] = new TableCell(expectedValueText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[3].setRowSpan(nodeCollectionList.size());
                    row[4] = new TableCell(collectionStatusText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                } else {
                    row = new TableCell[]{new TableCell(nodeNameText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null), new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null), new TableCell(collectionStatusText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null)};
                }
                table.addRow(row);
            }
        }
        return table;
    }

    private Table createHtmlTableForMultipleBaseLines(String reference, String targetName, String targetKey, ReportUtilConstants.TargetType targetType, boolean showFailuresOnly, HtmlPage htmlPage, String topNavigationTxt) throws ReportToolException, XmlReportToolException {
        int numberOfColumns = 1 + this.m_reportList.size() * 2;
        int numberOfColumnHeaders = 1 + this.m_reportList.size();
        String notApplicable = this.s_rptMsgBundle.getMessage("10026", false);
        String notAvailable = this.s_rptMsgBundle.getMessage("10027", false);
        Text topSymbol = new Text("&#8593;" + this.s_rptMsgBundle.getMessage("10055", false) + "&#8593;");
        topSymbol.setTextColor(HtmlConstants.Colors.DarkBlue);
        topSymbol.setBold(true);
        topSymbol.setReferencelink("#MAIN");
        topSymbol.setMouseOverDescription(this.s_rptMsgBundle.getMessage("10043", false));
        String topSymbolHtmlText = topSymbol.toHtmlString();
        Text targetDefination = new Text(targetName);
        targetDefination.setFontSize(5);
        targetDefination.setBold(true);
        targetDefination.setBookMarkName(reference);
        targetDefination.setTextColor(HtmlConstants.Colors.DarkGreen);
        HtmlConstants.Colors headerColor = HtmlConstants.Colors.LightSteelBlue;
        String captionStr = VerificationConstants.LINE_SEPARATOR + VerificationConstants.LINE_SEPARATOR + topSymbolHtmlText + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + targetDefination.toHtmlString() + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + "&#160;" + topSymbolHtmlText;
        Text caption = new Text(captionStr);
        TableCell[] headers = new TableCell[numberOfColumnHeaders];
        headers[0] = new TableCell(new Text(this.s_rptMsgBundle.getMessage("10003", false)), headerColor, null, null);
        headers[0].setWidth(20);
        int reportHeaderColumndWidth = Math.round(80 / this.m_reportList.size());
        int nodeNameColumntWidth = (int)Math.round((double)reportHeaderColumndWidth * 0.4);
        int nodeValueColumntWidth = (int)Math.round((double)reportHeaderColumndWidth * 0.6);
        TableCell[] secondHeaders = new TableCell[numberOfColumns];
        secondHeaders[0] = new TableCell(new Text(""), headerColor, null, null);
        int colStartIndex = 1;
        int headerStartIndex = 1;
        String idTextStr = this.s_rptMsgBundle.getMessage(targetType.name().contains("DATABASE") ? "10022" : "10052", false);
        int i = -1;
        for (String reportName : this.m_reportList.keySet()) {
            ++i;
            Text idText = new Text(idTextStr);
            idText.setBold(true);
            secondHeaders[colStartIndex] = new TableCell(idText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colStartIndex].setWidth(nodeNameColumntWidth);
            Text actualValueText = new Text(this.s_rptMsgBundle.getMessage("10025", false));
            actualValueText.setBold(true);
            secondHeaders[colStartIndex + 1] = new TableCell(actualValueText, headerColor, null, HtmlConstants.HorizontalAlignment.center);
            secondHeaders[colStartIndex + 1].setWidth(nodeValueColumntWidth);
            headers[headerStartIndex + i] = new TableCell(new Text(reportName), headerColor, null, null);
            headers[headerStartIndex + i].setColSpan(2);
            headers[headerStartIndex + i].setWidth(reportHeaderColumndWidth);
            colStartIndex += 2;
        }
        Table table = new Table(caption, headers, HtmlConstants.Colors.Black, HtmlConstants.Colors.DarkGoldenRod, 0);
        table.setWidth(99);
        table.addRow(secondHeaders);
        HashMap<String, HashMap<String, List<CollectionElement>>> baselineMap = this.getBaselines(this.m_reportList, targetKey);
        LinkedHashSet<String> mismatchErrorCollectionName = new LinkedHashSet<String>();
        LinkedHashSet<String> mismatchWarningCollectionName = new LinkedHashSet<String>();
        LinkedHashSet<String> matchCollectionName = new LinkedHashSet<String>();
        this.getSortedCollectionNames(baselineMap, mismatchErrorCollectionName, mismatchWarningCollectionName, matchCollectionName);
        ArrayList<String> collectionNames = new ArrayList<String>();
        collectionNames.addAll(mismatchErrorCollectionName);
        collectionNames.addAll(mismatchWarningCollectionName);
        collectionNames.addAll(matchCollectionName);
        for (String collectionName : collectionNames) {
            String msg = s_prvgMsgBundle.getMessage("11616", false, (Object[])new String[]{collectionName});
            if (!"TRUE".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_PRINT_MISMATCH"))) {
                ReportUtil.quietprintln(msg);
            }
            TableCell[] row = null;
            HashMap<String, HashMap<String, CollectionElement>> nodeWiseCollectionElements = this.getNodeWiseCollectionElements(collectionName, baselineMap);
            HtmlConstants.Colors rowColor = HtmlConstants.Colors.LightGrey;
            String str = null;
            LinkedHashSet<String> nodes = new LinkedHashSet<String>();
            for (String baselineName : this.m_reportList.keySet()) {
                HashMap<String, CollectionElement> nodeCollectionMap = nodeWiseCollectionElements.get(baselineName);
                if (nodeCollectionMap == null || nodeCollectionMap.size() <= 0) continue;
                nodes.addAll(nodeCollectionMap.keySet());
            }
            int nodeRowIndex = -1;
            TableCell collectionNameTableCell = null;
            String collectionDescString = null;
            Text collectionNameText = new Text(collectionName);
            for (String node : nodes) {
                colStartIndex = 0;
                if (++nodeRowIndex == 0) {
                    row = new TableCell[numberOfColumns];
                    colStartIndex = 1;
                } else {
                    row = new TableCell[numberOfColumns - 1];
                }
                Object referenceValue = null;
                boolean match = true;
                ArrayList<Text> actualValueTextList = new ArrayList<Text>();
                int baselineIndex = -1;
                for (String baselineName : this.m_reportList.keySet()) {
                    ++baselineIndex;
                    CollectionElement collectionElement = null;
                    if (nodeWiseCollectionElements.get(baselineName) != null) {
                        collectionElement = nodeWiseCollectionElements.get(baselineName).get(node);
                        nodeWiseCollectionElements.get(baselineName).remove(node);
                    }
                    HtmlConstants.Colors collectionRowColor = null;
                    collectionRowColor = (nodeRowIndex + 1) % 2 == 0 ? HtmlConstants.Colors.LightGrey : HtmlConstants.Colors.LightGrey;
                    if (collectionNameTableCell == null) {
                        collectionNameTableCell = new TableCell(collectionNameText, rowColor, HtmlConstants.VeriticalAlignment.top, null);
                    }
                    if (nodeRowIndex == 0) {
                        row[0] = collectionNameTableCell;
                    }
                    Text nodeNameText = new Text(node);
                    Text actualValTxt = new Text(notAvailable);
                    actualValueTextList.add(actualValTxt);
                    if (collectionElement != null) {
                        str = collectionElement.getDescription();
                        if (VerificationUtil.isStringGood(str)) {
                            collectionDescString = str;
                        }
                        if (collectionElement.getValue() != null) {
                            str = String.valueOf(collectionElement.getValue());
                            actualValTxt.setTextData(str);
                        }
                    }
                    row[colStartIndex] = new TableCell(nodeNameText, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[colStartIndex].setWidth(nodeNameColumntWidth);
                    row[colStartIndex + 1] = new TableCell(actualValTxt, collectionRowColor, HtmlConstants.VeriticalAlignment.top, null);
                    row[colStartIndex + 1].setWidth(nodeValueColumntWidth);
                    colStartIndex += 2;
                }
                HtmlConstants.Colors valueColor = null;
                if (mismatchErrorCollectionName.contains(collectionName)) {
                    valueColor = HtmlConstants.Colors.Red;
                } else if (mismatchWarningCollectionName.contains(collectionName)) {
                    valueColor = HtmlConstants.Colors.Darkorange;
                }
                for (Text text : actualValueTextList) {
                    text.setTextColor(valueColor);
                }
                collectionNameTableCell.setWidth(20);
                table.addRow(row);
            }
            collectionNameTableCell.setRowSpan(nodeRowIndex + 1);
            if (!VerificationUtil.isStringGood(collectionDescString)) continue;
            HtmlPopupPage popUpPage = this.createCollectionDescPopupPage("", collectionDescString, htmlPage.getBackgroundColor());
            collectionNameText.setInlinePopUpWindowsLink("#", popUpPage);
            collectionNameText.setTextColor(HtmlConstants.Colors.Black);
        }
        return table;
    }

    private HashMap<String, HashMap<String, List<CollectionElement>>> getBaselines(HashMap<String, CVXMLReportReader> reportList, String targetKey) throws XmlReportToolException {
        HashMap<String, HashMap<String, List<CollectionElement>>> baselineHM = new HashMap<String, HashMap<String, List<CollectionElement>>>();
        for (String reportName : reportList.keySet()) {
            HashMap<String, List<CollectionElement>> collectionHM = this.getCollectionSet(targetKey, reportList.get(reportName));
            baselineHM.put(reportName, collectionHM);
        }
        return baselineHM;
    }

    private HashMap<String, HashMap<String, CollectionElement>> getNodeWiseCollectionElements(String collectionName, HashMap<String, HashMap<String, List<CollectionElement>>> baselineList) {
        LinkedHashMap<String, HashMap<String, CollectionElement>> nodeWiseCollectionList = new LinkedHashMap<String, HashMap<String, CollectionElement>>();
        for (String baselineName : baselineList.keySet()) {
            HashMap<String, List<CollectionElement>> collectionHash = baselineList.get(baselineName);
            List<CollectionElement> nodeCollectionElementList = collectionHash.get(collectionName);
            if (nodeCollectionElementList == null || nodeCollectionElementList.size() == 0) continue;
            HashMap<String, CollectionElement> nodeWiseCollection = new HashMap<String, CollectionElement>();
            for (CollectionElement elem : nodeCollectionElementList) {
                nodeWiseCollection.put(elem.getNode(), elem);
            }
            nodeWiseCollectionList.put(baselineName, nodeWiseCollection);
        }
        return nodeWiseCollectionList;
    }

    private void getSortedCollectionNames(HashMap<String, HashMap<String, List<CollectionElement>>> baselineMap, Set<String> mismatchErrorCollectionName, Set<String> mismatchWarningCollectionName, Set<String> matchCollectionName) {
        LinkedHashSet<String> collectionNames = new LinkedHashSet<String>();
        for (String baseline : baselineMap.keySet()) {
            HashMap<String, List<CollectionElement>> collectionMap = baselineMap.get(baseline);
            collectionNames.addAll(collectionMap.keySet());
        }
        for (String collectionName : collectionNames) {
            HashMap<String, HashMap<String, CollectionElement>> nodeWiseCollectionElements = this.getNodeWiseCollectionElements(collectionName, baselineMap);
            LinkedHashSet<String> nodes = new LinkedHashSet<String>();
            for (String baseline : nodeWiseCollectionElements.keySet()) {
                HashMap<String, CollectionElement> collectionMap = nodeWiseCollectionElements.get(baseline);
                nodes.addAll(collectionMap.keySet());
            }
            boolean mismatchErrorFound = false;
            boolean mismatchWarningFound = false;
            boolean skipCollection = false;
            block3: for (String node : nodes) {
                String referenceValue = null;
                boolean referenceValueSet = false;
                for (String baseline : baselineMap.keySet()) {
                    HashMap<String, CollectionElement> collectionMap = nodeWiseCollectionElements.get(baseline);
                    if (collectionMap == null) {
                        mismatchErrorFound = true;
                        break block3;
                    }
                    CollectionElement collectionElement = collectionMap.get(node);
                    if (!referenceValueSet) {
                        referenceValueSet = true;
                        if (collectionElement != null && collectionElement.getValue() != null) {
                            referenceValue = String.valueOf(collectionElement.getValue());
                        }
                    } else if (referenceValue != null) {
                        if (collectionElement == null || collectionElement.getValue() == null) {
                            mismatchErrorFound = true;
                        } else if (referenceValue.equals(String.valueOf(collectionElement.getValue()))) {
                            mismatchErrorFound = false;
                            mismatchWarningFound = false;
                        } else if (this.isWithinDelta(referenceValue, String.valueOf(collectionElement.getValue()))) {
                            mismatchWarningFound = true;
                        } else {
                            mismatchErrorFound = true;
                        }
                    } else {
                        mismatchErrorFound = collectionElement != null && collectionElement.getValue() != null;
                    }
                    if (!mismatchErrorFound) continue;
                    break block3;
                }
            }
            if (skipCollection) continue;
            if (mismatchErrorFound) {
                mismatchErrorCollectionName.add(collectionName);
                this.m_mismatches.add(collectionName);
                continue;
            }
            if (mismatchWarningFound) {
                mismatchWarningCollectionName.add(collectionName);
                continue;
            }
            matchCollectionName.add(collectionName);
        }
    }

    private boolean isWithinDelta(String referenceValue, String string) {
        Double referenceValueDouble = this.getNumPart(referenceValue);
        Double actualValueDouble = this.getNumPart(string);
        double differencePercentage = Math.abs(actualValueDouble - referenceValueDouble) / referenceValueDouble * 100.0;
        return differencePercentage <= (double)this.m_delta;
    }

    private Double getNumPart(String string) {
        Pattern fractionalPattern = Pattern.compile("([\\d]+)\\.([\\d]+)(.*)");
        Matcher m = fractionalPattern.matcher(string);
        if (m.matches()) {
            return Double.parseDouble(m.group(1) + "." + m.group(2));
        }
        Pattern wholeNumberPattern = Pattern.compile("([\\d]+)(.*)");
        m = wholeNumberPattern.matcher(string);
        if (m.matches()) {
            return Double.parseDouble(m.group(1));
        }
        return 0.0;
    }

    private HtmlPopupPage createCollectionDescPopupPage(String heading, String paraGraph, HtmlConstants.Colors backgroundColor) throws ReportToolException {
        HtmlPopupPage popUpPage = null;
        popUpPage = new HtmlPopupPage(heading, null, backgroundColor, false, true);
        if (VerificationUtil.isStringGood(heading)) {
            Text headingTxt = new Text(heading);
            popUpPage.addHeadingToHtmlBody(headingTxt, 3, null);
        }
        if (VerificationUtil.isStringGood(paraGraph)) {
            Text paraGraphTxt = new Text(paraGraph);
            popUpPage.addParagraphToHtmlBody(paraGraphTxt, null);
        }
        return popUpPage;
    }

    private HtmlPopupPage createCollectionErrorPopupPage(String heading, List<ErrorDescription> errorList, HtmlConstants.Colors backgroundColor) throws ReportToolException {
        HtmlPopupPage popUpPage = null;
        popUpPage = new HtmlPopupPage(heading, null, backgroundColor, false, true);
        if (VerificationUtil.isStringGood(heading)) {
            Text headingTxt = new Text(heading);
            popUpPage.addHeadingToHtmlBody(headingTxt, 3, null);
        }
        for (ErrorDescription error : errorList) {
            Text paraGraphTxt = new Text(error.getErrorMessage());
            popUpPage.addParagraphToHtmlBody(paraGraphTxt, null);
        }
        return popUpPage;
    }

    public List<String> getMismatchesFound() {
        return this.m_mismatches;
    }
}

